// ============================================================== eval-d1-4.c
//
// Evaluation of validation d1-4 (CEDVAL D1-4, Uttenweiler)
// =========================================================
//
// Copyright (C) Umweltbundesamt, 14191 Berlin, Germany, 2004
// Copyright (C) Janicke Consulting, 26427 Dunum, Germany, 2004
// email: info@austal2000.de
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of
// the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// last change: 2004-08-28 uj
//
//===========================================================================

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define CC(i,j,k)  Cc[((i-1)*Ny+j-1)*Nz+k-1]
#define DD(i,j,k)  Dd[((i-1)*Ny+j-1)*Nz+k-1]
#define EX(i)  Ee[i*4+0]
#define EY(i)  Ee[i*4+1]
#define EZ(i)  Ee[i*4+2]
#define EC(i)  Ee[i*4+3]

static char Path[256];
static char *FileCnc = "xx-%03dz.dmna";
static char *FileDev = "xx-%03ds.dmna";
static char *FileExp = "D1-4-TR.TXT";
static int Nx=81, Ny=41, Nz=21, Ne=45;
static double *Cc, *Dd, *Ee;
static double X0=-81.5, Y0=-61.5, Dx=3, Dy=3, Dz=2;

int equals(double f1, double f2) {
  return (fabs(f1-f2) < 0.001) ? 1 : 0;
}

//==================================================================== main

int main( int argc, char *argv[] ) {
  char s[256], fn[256], buf[4000]="", *pc, name[256];
  int i, j, k, l, n, ip, nx, ny, nz;
  double x, y, z, c, d, ce, z1, z2;
  FILE *f;
  
  if (argc < 2) {
    printf("Aufruf: eval-d1-4 <Ordner>\n");
    exit(0);
  }
  strcpy(Path, argv[1]);
  
  printf("Test %s:\n", Path);
  n = 1;
  sprintf(name, FileCnc, n);
  sprintf(fn, "%s/%s", Path, name);
  f = fopen(fn, "r");                           // Datei ffnen
  if (!f) {
    printf("*** Datei \"%s\" kann nicht gelesen werden!\n", fn);
    exit(1);
  }
  while(fgets(buf, 4000, f)) {                  // Header berspringen
    l++;
    if (!strncmp(buf,"hghb", 4)) {
      sscanf(buf+4, "%d%d%d", &Nx, &Ny, &Nz);
      if (Nx>100 || Ny>100 || Nz>100) {
        printf("*** Ungltige Dateistruktur in \"%s\"!", fn);
        exit(10);
      }
      Cc = malloc(Nx*Ny*Nz*sizeof(double));
    }
    if (*buf == '*')  break;
  }
  if (*buf != '*') {
    printf("*** Datenteil in Datei \"%s\" nicht gefunden!\n", fn);
    exit(2);
  }
  for (k=1; k<=Nz; k++) {
    for (j=Ny; j>0; ) {
      if (!fgets(buf, 4000, f)) {                 // Zeilenweise einlesen
        printf("*** EOF fr j=%d, k=%d gefunden!\n", j, k);
        exit(3);
      }
      pc = strtok(buf, " \t\r\n");
      if (!pc)  continue;
      for (i=1; i<=Nx; i++) {
        if (!pc) {
          printf("Datenelement (%d,%d,%d) nicht gefunden!\n", i, j, k);
          exit(5);
        }
        if (1 != sscanf(pc, "%lf", &c))  {
          printf("Datenelement (%d,%d,%d) nicht lesbar!\n", i, j, k);
          exit(4);
        }
        CC(i,j,k) = c;
        pc = strtok(NULL, " \t\r\n");
      } // for i
      j--;
    } // for j
  } // for k
  fclose(f);
  f = NULL;

  //

  sprintf(name, FileDev, n);
  sprintf(fn, "%s/%s", Path, name);
  f = fopen(fn, "r");                           // Datei ffnen
  if (!f) {
    printf("*** Datei \"%s\" kann nicht gelesen werden!\n", fn);
    exit(1);
  }
  while(fgets(buf, 4000, f)) {                  // Header berspringen
    if (!strncmp(buf,"hghb", 4)) {
      sscanf(buf+4, "%d%d%d", &nx, &ny, &nz);
      if (Nx!=nx || Ny!=ny || Nz!=nz) {
        printf("*** Ungltige Dateistruktur in \"%s\"!", fn);
        exit(10);
      }
      Dd = malloc(Nx*Ny*Nz*sizeof(double));
    }
    if (*buf == '*')  break;
  }
  if (*buf != '*') {
    printf("*** Datenteil in Datei \"%s\" nicht gefunden!\n", fn);
    exit(2);
  }
  for (k=1; k<=Nz; k++) {
    for (j=Ny; j>0; ) {
      if (!fgets(buf, 4000, f)) {                 // Zeilenweise einlesen
        printf("*** EOF fr j=%d, k=%d gefunden!\n", j, k);
        exit(3);
      }
      pc = strtok(buf, " \t\r\n");
      if (!pc)  continue;
      for (i=1; i<=Nx; i++) {
        if (!pc) {
          printf("Datenelement (%d,%d,%d) nicht gefunden!\n", i, j, k);
          exit(5);
        }
        if (1 != sscanf(pc, "%lf", &d))  {
          printf("Datenelement (%d,%d,%d) nicht lesbar!\n", i, j, k);
          exit(4);
        }
        DD(i,j,k) = d/100.;
        pc = strtok(NULL, " \t\r\n");
      } // for i
      j--;
    } // for j
  } // for k
  fclose(f);
  f = NULL;
  
  //
  
  sprintf(fn, "%s/%s", Path, FileExp);
  f = fopen(fn, "r");                           // Datei ffnen
  if (!f) {
    printf("*** Datei \"%s\" kann nicht gelesen werden!\n", fn);
    exit(1);
  }
  Ee = malloc(Ne*4*sizeof(double));
  l = -1;
  while(fgets(buf, 4000, f)) {   
    if (!strncmp(buf,"S = 3", 5)) l = 0;   
    if (l >= 0) {
      for (i=0; i<strlen(buf); i++) if (buf[i] == 'E') buf[i] = 'e';
      n = (l == 0) ? 5 : 0;
      n = sscanf(buf+n, "%d%lf%lf%lf%lf", &i, &x, &y, &z, &c);
      if (n != 5) {
        printf("*** Datei \"%s\" kann nicht ausgelesen werden!\n", fn);
        exit(1);
      }
    }
    else continue;
    EX(l) = x;
    EY(l) = y;
    EZ(l) = z;
    EC(l) = c * 1.e3;
//printf("l=%d, x=%5.1f, y=%5.1f, z=%5.1f, c=%5.2f\n", l, EX(l), EY(l), EZ(l), EC(l));
    l++;
    if (l >= Ne) break;
  }

  //
  
  for (n=0; n<=1; n++) {
    x = (n==0) ? 50. : 100.;
    y = 0;    
    for (i=1; i<=Nx; i++) if ((X0+Dx*i) > x) break;
    for (j=1; j<=Ny; j++) if ((Y0+Dy*j) > y) break;
    if (i > Nx || j > Ny) {
      printf("*** Falsches Dateiformat!");
      exit(1);
    }
    printf(" X = %1.0lf m:\n", x);
    printf(" Z1(m)  Z2(m)     Ze(m)    Dev Cm/Cs  Cme/Cs\n");
    for (k=Nz; k>=1; k--) {
      z2 = Dz*k;
      z1 = z2-Dz;
      for (l=0; l<Ne; l++) {
        if (equals(EX(l),x) && equals(EY(l),y) && EZ(l)>=z1 && EZ(l)<z2)
          break;
      }
      if (l >= Ne)
        printf("   %3.0lf    %3.0lf      %4s   %4.2lf %5.2lf   %5s\n",
          z1, z2, "----",  DD(i,j,k), CC(i,j,k),  "----");
      else
        printf("   %3.0lf    %3.0lf      %4.1f   %4.2lf %5.2lf   %5.2lf\n", 
          z1, z2, EZ(l), DD(i,j,k), CC(i,j,k),   EC(l));
    }
  }
  printf("\n");
  return 0;
}

